#version 420

uniform sampler2D loadbar_background;
uniform sampler2D loadbar_foreground;
uniform sampler2D loadbar_halfglow;
uniform sampler2D loadbar_quarterglow;
uniform float brightness;

in vec2 out_TexCoord;

out vec4 fragColor;

void main()
{
	vec4 bg = texture2D(loadbar_background, out_TexCoord);
	vec4 fg = texture2D(loadbar_foreground, out_TexCoord);
	vec4 halfglow = texture2D(loadbar_halfglow, out_TexCoord);
	vec4 quarterglow = texture2D(loadbar_quarterglow, out_TexCoord);
	//fragColor = mix(t0, t1, t1.a);
	//fragColor = t0 + t1;
	fragColor = (bg + fg + ((halfglow + quarterglow) / 2)) * brightness;
}